<?php

namespace App\Http\Classes;

use Illuminate\Support\Facades\Auth;

class Notification {

    protected $redis;

    public function __construct($redis){
        $this->redis = $redis;
    }

    public function getNotificationByType($request, $notification_type){
        $notifications = $this->redis->zrevrangebyscore('user:'.Auth::id().':notification:'.$notification_type.'', '+inf', '-inf', 'limit', $request->off_set, $request->count, 'withscores');

        return $notifications;
    }

    public function countNotificationByType($notification_type){
        $notifications = $this->redis->zcount('user:'.Auth::id().':notification:'.$notification_type.'', '-inf', '+inf');
        return $notifications;
    }

    public function today($request, $notification_type){
        $ts = time();
        $tsString = explode(':', date("h:m:s", $ts));
        $tsHoursToSecond = $tsString[0] * 3600;
        $tsMinutesToSecond = $tsString[1] * 60;
        $tsSeconds = $tsString[2];
        $tsTotal = $tsHoursToSecond + $tsMinutesToSecond + $tsSeconds;
        $ts = time() - ($tsTotal);
        if ($request) {
            $notifications = $this->redis->zrevrangebyscore('user:'.Auth::id().':notification:'.$notification_type.'', time(), $ts, 'limit', $request->off_set, $request->count, 'withscores');
        }else {
            $notifications = $this->redis->zrevrangebyscore('user:'.Auth::id().':notification:'.$notification_type.'', time(), $ts, 'withscores');
        }
        return $notifications;
    }

    public function yesterday($request, $notification_type){
        $ts = time();
        $tsString = explode(':', date("h:m:s", $ts));
        $tsHoursToSecond = $tsString[0] * 3600;
        $tsMinutesToSecond = $tsString[1] * 60;
        $tsSeconds = $tsString[2];
        $tsTotal = $tsHoursToSecond + $tsMinutesToSecond + $tsSeconds;
        $ts = time() - ($tsTotal);
        $yesterday = time() - (86400 * 1);
        
        $notifications = $this->redis->zrevrangebyscore('user:'.Auth::id().':notification:'.$notification_type.'', $ts, $yesterday, 'limit', $request->off_set, $request->count, 'withscores');

        return $notifications;
    }

    public function thisWeek($request, $notification_type){
        $dowMap = array('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat');
        $lastWeek = time() - (86400 * array_search(date('D'), $dowMap));
        $ts = time();
        
        $notifications = $this->redis->zrevrangebyscore('user:'.Auth::id().':notification:'.$notification_type.'', $ts, $lastWeek, 'limit', $request->off_set, $request->count, 'withscores');

        return $notifications;
    }

    public function thisMonth($request, $notification_type){
        $ts = time();
        $thisMonth = time() - (86400 * (date('d') - 1));

        $notifications = $this->redis->zrevrangebyscore('user:'.Auth::id().':notification:'.$notification_type.'', $ts, $thisMonth, 'limit', $request->off_set, $request->count, 'withscores');

        return $notifications;
    }

    public function thisYear($request, $notification_type){
        $ts=time();
        $thisYear=time() - (86400 * (date('z')));

        $notifications = $this->redis->zrevrangebyscore('user:'.Auth::id().':notification:'.$notification_type.'', $ts, $thisYear, 'limit', $request->off_set, $request->count, 'withscores');

        return $notifications;
    }

    public function countToday($notification_type){
        $ts = time();
        $tsString = explode(':', date("h:m:s", $ts));
        $tsHoursToSecond = $tsString[0] * 3600;
        $tsMinutesToSecond = $tsString[1] * 60;
        $tsSeconds = $tsString[2];
        $tsTotal = $tsHoursToSecond + $tsMinutesToSecond + $tsSeconds;
        $ts = time() - ($tsTotal);
        $notifications = $this->redis->zcount('user:'.Auth::id().':notification:'.$notification_type.'', $ts, time());

        return $notifications;
    }

    public function countYesterday($notification_type){
        $ts = time();
        $tsString = explode(':', date("h:m:s", $ts));
        $tsHoursToSecond = $tsString[0] * 3600;
        $tsMinutesToSecond = $tsString[1] * 60;
        $tsSeconds = $tsString[2];
        $tsTotal = $tsHoursToSecond + $tsMinutesToSecond + $tsSeconds;
        $ts = time() - ($tsTotal);
        $yesterday = time() - (86400 * 1);
      
        $notifications = $this->redis->zcount('user:'.Auth::id().':notification:'.$notification_type.'', $yesterday, $ts);

        return $notifications;
    }

    public function countThisWeek($notification_type){
        $dowMap = array('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat');
        $thisWeek = time() - (86400 * array_search(date('D'), $dowMap));
        $ts = time();
    
        $notifications = $this->redis->zcount('user:'.Auth::id().':notification:'.$notification_type.'', $thisWeek, $ts);
        
        return $notifications;
    }

    public function countThisMonth($notification_type){
        $ts = time();
        $thisMonth = time() - (86400 * (date('d') - 1));

        $notifications = $this->redis->zcount('user:'.Auth::id().':notification:'.$notification_type.'', $thisMonth, $ts);

        return $notifications;
    }

    public function countThisYear($notification_type){
        $ts = time();
        $thisYear = time() - (86400 * (date('z')));

        $notifications = $this->redis->zcount('user:'.Auth::id().':notification:'.$notification_type.'', $thisYear, $ts);

        return $notifications;
    }
}