<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class ApplySignature implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $fileVersionID;
    public $isSigningDocument;
    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct($fileVersionID, $isSigningDocument)
    {
        $this->fileVersionID = $fileVersionID;
        $this->isSigningDocument = $isSigningDocument;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new Channel('signature.' . $this->fileVersionID);
    }

    public function broadcastAs()
    {
        return 'isSigningDocument';
    }
}
