<?php

namespace App\Console;

use App\Console\Commands\generateMonthlyLeaveCredits;
use App\Console\Commands\generateYearlyLeaveCredits;
use App\Console\Commands\initLeaveBalances;
use App\Console\Commands\archiveFiles;
use App\Console\Commands\SyncBiometricsAttendance;
use App\Console\Commands\StatusDeactiveUpdate;
use App\Enums\Biometrics\AutoSync;
use Exception;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Suiterus\Adg\Models\Setting;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        generateMonthlyLeaveCredits::class,
        generateYearlyLeaveCredits::class,
        initLeaveBalances::class,
        archiveFiles::class,
        SyncBiometricsAttendance::class,
        StatusDeactiveUpdate::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $schedule->command('leave:deduct-forced-leave-to-vacation-leave')->yearly();
        $schedule->command('update:employee-type-history-status')->daily();
        $schedule->command('generate:pending-reports')->everyMinute()->withoutOverlapping();
        $schedule->command('queue:work --stop-when-empty')->everyMinute();
        $schedule->command('Salary_grades:StepIncrement')->yearly();
        $schedule->command('Applicant_account:StatusDeactiveUpdate')->yearly();
        $schedule->command('generate:monthly-leave-credits')->monthly();
        $schedule->command('generate:yearly-leave-credits')->yearly();
        $schedule->command('archive:files')->everyMinute();
        $schedule->command('reset:yearly-coc-points')->yearly();

        // Biometrics attendance synchronization when enabled
        // $minutes = Setting::where('key', 'auto-sync-attendance-time')->first();

        // if ($minutes) {
        //     $minutesValue = (int) $minutes->value;
        //     $schedule->command('sync:biometrics-attendance')->cron("*/$minutesValue * * * *")
        //     ->when(function() {
        //         try {
        //             $autosync = Setting::where('key', 'auto-sync-attendance')->first();
        //             if($autosync->value == AutoSync::ENABLED) {
        //                 return true;
        //             }
        //             return false;
        //         } catch(Exception $e) {
        //             echo $e->getMessage();
        //             return false;
        //         }
        //     })
        //     ->appendOutputTo(storage_path('logs') . '/attendance-sync-logs.txt');
        // }
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
