<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Suiterus\Adg\Models\EMI\EmployeeMetaInfo;
use Suiterus\Hrjp\Models\Position_history;

class fixPositionID extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'fix:position_id';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'The value of position_id in employee_meta_info table and position_histories must be the same.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $employees = EmployeeMetaInfo::get();

        foreach($employees as $employee){
            $position_history = Position_history::where('user_id', $employee->user_id)->orderBy('created_at','desc')->first();
            if($position_history){
                if($employee->position_id != $position_history->position_id){
                    $position_history->update([
                        'position_id' => $employee->position_id
                    ]);
                }
            } 
        }

        return Command::SUCCESS;
    }
}
