<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;
use Suiterus\Adg\Models\ActualDesignation;
use Suiterus\Adg\Models\SM\Office;
use Suiterus\Adg\Models\EMI\EmployeeMetaInfo;
use Suiterus\Adg\Models\SPMS\EmployeeEvaluation;
use Suiterus\Adg\Models\SPMS\EvaluationClassification;
use Suiterus\Adg\Models\SPMS\MetricEvaluation;
use Suiterus\Adg\Models\SPMS\PCRFormType;
use Suiterus\Adg\Models\SPMS\PerformanceEvaluation;
use Suiterus\Adg\Models\SPMS\Mfo;
use Carbon\Carbon;

class UploadPCRData extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'upload:nhims_pcr_data {pcr_type} {eval_file_name} {mfo_file_name}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Uploading of Employee`s Evaluations';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $evalFileNames = explode('|', $this->argument('eval_file_name'));
        $mfoFileNames = explode('|', $this->argument('mfo_file_name'));
        $pcr_type = $this->argument('pcr_type');
        
        $pcr_form_type = PCRFormType::where('abbreviation', $pcr_type)->first();

        $excelEmpIds = [];

        foreach ($evalFileNames as $evalFileName) {
            $row = 1;
            $countProcess = 0;
            $countEmployeeNotExist = 0;

            $fileNotExistPath = public_path(($evalFileName. '.csv') . '-employee-exist-in-excel-not-in-database.csv');
            $fileNotExist = fopen($fileNotExistPath, 'w');
            $employeeInDb = fopen(public_path(($evalFileName. '.csv') . '-employee-exist-in-database-not-in-excel.csv'), 'w');
            $evaluationFile = public_path($evalFileName. '.csv');

            fputcsv($fileNotExist, [
                'Employee ID', 'LAST NAME', 'FIRST NAME', 'MIDDLE NAME', 'IPCR_ID',	'IPCR_From',	'IPCR_To',	'IPCR_Created', 'EmpID_ApprovedBy',	'IPCR_ApprovedBy',	'IPCR_ApprovedBy_Pos',	'EmpID_ApprovedBy2',	'IPCR_ApprovedBy2',	'IPCR_ApprovedBy_Pos2', 'DEPUTY', 'DEPARTMENT', 'DIVISION / SECTION / UNIT (AREA OF ASSIGNMENT)'
            ]);

            if (($evalHandle = fopen($evaluationFile, 'r')) !== false) {
                while (($data = fgetcsv($evalHandle, 10000, ",")) !== false) {
                    if ($row > 2) {
                        $excelEmpIds[] = sprintf("%06d", $data[0]);
                        $ipcrId = $data[4];

                        $employee = [
                            'employee_id'   =>  $data[0],
                            'last_name' =>  $data[1],
                            'first_name'    =>  $data[2],
                            'middle_name'   =>  $data[3],
                            'ipcr_id'   => $data[4],
                            'start_date'    =>  $data[5],
                            'end_date'  =>  $data[6],
                            'created_date'  =>  $data[7],
                            'evaluator_emp_id'  =>  $data[8],
                            'evaluator_name'    =>  $data[9],
                            'evaluator_position'    =>  $data[10],
                            'approver_emp_id'   =>  $data[11],
                            'approver_name' =>  $data[12],
                            'approver_position' =>  $data[13],
                            'office'    =>  $data[14],
                            'department'    =>  $data[15],
                            'division'  =>  $data[16]
                        ];

                        $user = User::whereHas('employeeMetaInfo', function ($query) use ($employee) {
                            $query->where('employee_id', $employee['employee_id']);
                        })->without(['currentRole', 'roles', 'permissions', 'storage', 'employeeMetaInfo', 'supervisor', 'user_supervisor', 'exitInterview','userProfilePicture','profileBasicInfo'])->first();

                        if (!$user) {
                            $this->error("Employee not exist: {$employee['employee_id']} - {$employee['last_name']}, {$employee['first_name']}");
                            fputcsv($fileNotExist, $data);
                            $countEmployeeNotExist++;
                            continue;
                        }

                        if ($user){
                            $actualDesignation = ActualDesignation::where('user_id', $user->id)->first();
                
                            $evaluator = User::select('id')->whereHas('employeeMetaInfo', function ($query) use ($employee) {
                                $query->where('employee_id', $employee['evaluator_emp_id']);
                            })->without(['currentRole', 'roles', 'permissions', 'storage', 'employeeMetaInfo', 'supervisor', 'user_supervisor', 'exitInterview','userProfilePicture','profileBasicInfo'])->first();
                            
                            if (!$evaluator) {
                                $this->error("Evaluator of {$employee['employee_id']} - {$employee['last_name']}, {$employee['first_name']} didn`t exist: {$employee['evaluator_emp_id']} - {$employee['evaluator_name']}");
                                fputcsv($fileNotExist, $data);
                                continue;
                            }

                            $approver = User::select('id')->whereHas('employeeMetaInfo', function ($query) use ($employee) {
                                $query->where('employee_id', $employee['approver_emp_id']);
                            })->without(['currentRole', 'roles', 'permissions', 'storage', 'employeeMetaInfo', 'supervisor', 'user_supervisor', 'exitInterview','userProfilePicture','profileBasicInfo'])->first();

                            if (!$approver) {
                                $this->error("Approver of {$employee['employee_id']} - {$employee['last_name']}, {$employee['first_name']} didn`t exist: {$employee['approver_emp_id']} - {$employee['approver_name']}");
                            }

                            if($evaluator) {
                                $evaluation = EmployeeEvaluation::create([
                                    'employee_id'   =>  $user->id,
                                    'evaluator' =>  $evaluator->id,
                                    'approver'  =>  !$approver ? null : $approver->id,
                                    'office_id' =>  $actualDesignation ? $actualDesignation->office_id : null,
                                    'department_id' =>  $actualDesignation ? $actualDesignation->department_id : null,
                                    'division_id'   =>  $actualDesignation ? $actualDesignation->division_id : null,
                                    'section_id'    =>  $actualDesignation ? $actualDesignation->section_id : null,
                                    'unit_id'   =>  $actualDesignation ? $actualDesignation->unit_id : null,
                                    'start_date'    =>  $employee['start_date'],
                                    'end_date'  =>  $employee['end_date'],
                                    'review_form_type'  =>  $pcr_form_type->id,
                                    'status'    =>  10, // DONE
                                    'created_at'    =>  $employee['created_date']
                                ]);

                                if($evaluation){
                                    $this->info($employee['employee_id'] .' | '. $user->name);
                                }
                            
                                foreach ($mfoFileNames as $mfoFileName) {
                                    $mfoFile = public_path($mfoFileName. '.csv');

                                    if (($mfoHandle = fopen($mfoFile, 'r')) !== false) {
                                        while (($record = fgetcsv($mfoHandle, 10000, ",")) !== false) {
                                            if ($row > 2) {
                                                if($ipcrId == $record[1])  {
                                                    $mfo_id = explode(':', $record[3])[0];
                                                    if ($mfo_id == 2){
                                                        $mfo_id = 3;
                                                    }else if ($mfo_id == 3) {
                                                        $mfo_id = 2;
                                                    }

                                                    $entry = [
                                                        'employee_id'   =>  $record[0],
                                                        'mfo'   =>  $mfo_id,
                                                        'description'  =>  $record[4],
                                                        'classification'    =>  $record[5],
                                                        'success_q' =>  $record[6],
                                                        'success_e' =>  $record[7],
                                                        'success_t' =>  $record[8],
                                                        'actual_q'  =>  $record[9],
                                                        'actual_e'  =>  $record[10],
                                                        'actual_t'  =>  $record[11],
                                                        'rating_q'  =>  $record[12],
                                                        'rating_e'  =>  $record[13],
                                                        'rating_t'  =>  $record[14],
                                                        'average_qet'   =>  $record[15],
                                                        'remarks_q' =>  $record[16],
                                                        'remarks_e' =>  $record[17],
                                                        'remarks_t' =>  $record[18]
                                                    ];

                                                    $performanceEvaluation = PerformanceEvaluation::create([
                                                        'evaluation_id' =>  $evaluation->id,
                                                        'mfo'   =>  $mfo_id
                                                    ]);

                                                    $eval_classification = EvaluationClassification::updateOrCreate([
                                                        'title' => $entry['classification']
                                                    ]);

                                                    MetricEvaluation::create([
                                                        'performance_eval_id'   =>  $performanceEvaluation->id,
                                                        'eval_classification_id'    =>  $eval_classification->id,
                                                        'description'   =>  $entry['description'],
                                                        'success_q'   =>  $entry['success_q'],
                                                        'success_e'   =>  $entry['success_e'],
                                                        'success_t'   =>  $entry['success_t'],
                                                        'actual_q'   =>  $entry['actual_q'],
                                                        'actual_e'   =>  $entry['actual_e'],
                                                        'actual_t'   =>  $entry['actual_t'],
                                                        'rate_q'   =>  $entry['rating_q'] == '' ? null : $entry['rating_q'],
                                                        'rate_e'   =>  $entry['rating_e'] == '' ? null : $entry['rating_e'],
                                                        'rate_t'   =>  $entry['rating_t'] == '' ? null : $entry['rating_t'],
                                                        'remarks_q'   =>  $entry['remarks_q'],
                                                        'remarks_e'   =>  $entry['remarks_e'],
                                                        'remarks_t'   =>  $entry['remarks_t'],
                                                        'average'   =>  $entry['average_qet'],
                                                        'status'   =>  11 // RATING_APPROVED_BY_APPROVER                        
                                                    ]);
                                                }
                                            }
                                            $row++;
                                        }
                                    }
                                }
                            } 
                        }else {
                            $this->error($employee['employee_id']. ' '. $employee['last_name']);
                        }

                        $countProcess++;
                    }
                    $row++;
                }
                fclose($mfoHandle);
                fclose($evalHandle);
            }

            $infos = EmployeeMetaInfo::whereNotIn('employee_id', $excelEmpIds)->get();

            foreach ($infos as $info) {
                fputcsv($employeeInDb, [
                    $info->employee_id,
                    $info->user->name
                ]);
            }

            $this->info('Seeding of ' .$evalFileName . ' done');
            $this->info('Total of ' .$countProcess . ' employee(s) imported');
            $this->info('Total of ' .$countEmployeeNotExist . ' employee(s) not exist in database');
            $this->info('File ' .$evalFileName . '-employee-not-exist.csv created');
            fclose($employeeInDb);
            fclose($fileNotExist);
        }   
    }         
}
