<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Suiterus\Adg\Models\Salary\PublicSalary;
use Suiterus\Adg\Models\SM\SalaryGrade;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use Suiterus\Adg\Models\ServiceRecord\ServiceRecord;
use Suiterus\Adg\Models\SM\Remark;
use Suiterus\Adg\Models\EMI\EmployeeMetaInfo;
use Illuminate\Support\Facades\Auth;
use Suiterus\Adg\Models\Salary\EmployeeAllowance;

class StepIncrement extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'Salary_grades:StepIncrement';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Salary Grades Step Increment';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $currentDate = Carbon::now()->format('Y-m-d');
        
        $allPublic = PublicSalary::with(['salaryGrade' => function ($query){
            $query->where('status', 1);
        }])->with('userSalary')->get();

        foreach($allPublic as $public){
            $publicDate = Carbon::parse($public->updated_at);
            $year = $publicDate->diffInYears($currentDate);
            $step[] = $public['salaryGrade']['step'];
            if($year === 3){
                foreach($step as $steps){
                    $salaryStep = $steps;
                }

                if($salaryStep != 8){
                    PublicSalary::where('id', $public->id)->update([ 'salary_grade_id' => $public->salary_grade_id + 1]);

                    $userId[] = $public['userSalary']['user_id'];
                    foreach($userId as $users){
                        $user = $users;
                    }

                    $newSalary = SalaryGrade::whereHas('publicSalary', function($query) use($user){
                        $query->whereHas('userSalary', function($query) use($user){
                            $query->where([
                                ['user_id', $user]
                            ]);
                        });
                    })->first();

                    $totalAllowance = 0;

                    $allowance = EmployeeAllowance::where('user_id', $user)->get();

                    
                    foreach($allowance as $allowances) {
                        $totalAllowance += $allowances['amount'];
                    }

                    if($allowance === null){
                        $allAllowances = 0;
                    }
                    else{
                        $allAllowances = $totalAllowance;
                    }

                    $salary = $newSalary->value;
                    $salary = str_replace( ',', '', $salary);
                    $annualSalary = $salary * 12;

                    $employee = EmployeeMetaInfo::where('user_id', $user)->first();

                    $oldServiceRecord = ServiceRecord::where('user_id', $user)->whereNull('end_date');
                        $endDate = date('Y-m-d', strtotime(now()));
                        $oldServiceRecord->update([
                            'end_date'  => $endDate
                        ]);

                    
                    $remark = Remark::whereId(20)->first();
                    ServiceRecord::create([
                        'user_id'           =>  $user,
                        'start_date'        =>  now(), 
                        'position_id'       =>  $employee->position_id,
                        'salary'            =>  $annualSalary,
                        'allowance'         =>  $allAllowances,
                        'employee_type_id'  =>  $employee->employee_type,
                        'division_id'       =>  $employee->division_id,
                        'remark_id'         =>  $remark->id,  //* Step Increment
                        'created_by'        =>  2
                    ]);
                }

               
                
            }
            Log::info($year.'test');
        }
    }
}
