<?php

namespace App\Console\Commands;


use Illuminate\Console\Command;
use Suiterus\Hrjp\Models\Application as AC;
use Carbon\Carbon;

class StatusDeactiveUpdate extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'Applicant_account:StatusDeactiveUpdate';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Applicantion Status Update';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $currentDate = Carbon::now()->format('Y-m-d');
        $Allusers = AC::where('status', 1)->get();
        foreach($Allusers as  $user){
            $userDate = Carbon::parse($user->created_at);
            $year = $userDate->diffInYears($currentDate);
            if($year > 0){
                AC::where('id',$user->id)->update([ 'status' => 3]);
            }
        }
    }
}
