<?php

namespace App\Console\Commands;

use App\Enums\ReportStatus;
use Exception;
use Illuminate\Console\Command;
use Suiterus\Adg\Exceptions\Reports\ReportException;
use Suiterus\Adg\Factories\ReportFactory;
use Suiterus\Adg\Models\Reports\Reports;

class GeneratePendingReport extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'generate:pending-reports';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate pending report from the reports table';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $reports = Reports::where('status', ReportStatus::PENDING)->get();

        foreach ($reports as $report) {
            try {
                $report->update([
                    'status' => ReportStatus::RUNNING
                ]);
                $snapshot = ReportFactory::create($report['report_type'])->generate($report['id']);
                $report->update([
                    'status' => ReportStatus::COMPLETED,
                    'remarks' => 'Success',
                    'snapshot' => $snapshot,
                ]);
            } catch (ReportException $e) {
                $report->update([
                    'status' => ReportStatus::FAILED,
                    'remarks' => $e->getMessage()
                ]);
            } catch (Exception $e) {
                $report->update([
                    'status' => ReportStatus::FAILED,
                    'remarks' => 'An error occurred while generating your report'
                ]);
            }
        }

        return Command::SUCCESS;
    }
}
