<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Suiterus\Dms\Models\Files\FileVersion;
use Suiterus\Dms\Models\OtherAttachments\OtherAttachments;
use Suiterus\Dms\Models\Signatory\FileSignatory;
use Suiterus\Dms\Models\Signatory\FileSignatorySignature;

class GenerateFileVersionPath extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'generate:file-version-path';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generates the file path of each file version';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        $fileVersions = FileVersion::all();

        foreach ($fileVersions as $version) {
            FileVersion::where('id', $version['id'])->withTrashed()->update([
                'path' => $this->getFileVersionPath($version['created_by'], $version['file']['section_id'], $version['file_id'], $version['file_version'], $version['file_name'])
            ]);

            $fileSignatory = FileSignatory::where('file_version_id', $version['id'])->first();
            $fileOtherAttachments = OtherAttachments::where('file_id', $version['file_id'])->get()->makeVisible('path');

            if ($fileSignatory) {
                $oldFileSignatorySignature = FileSignatorySignature::where('file_signatory_id', $fileSignatory->id)->first();

                FileSignatorySignature::updateOrCreate(
                    [
                        ['id', $oldFileSignatorySignature->id]
                    ],
                    [
                        'document_encrypted_path' => $this->getFileVersionSignaturePath($version['created_by'], $version['file']['section_id'], $version['file_id'], $version['file_version'], basename($oldFileSignatorySignature->document_encrypted_path)),
                        'document_signature_path' => $this->getFileVersionSignaturePath($version['created_by'], $version['file']['section_id'], $version['file_id'], $version['file_version'], basename($oldFileSignatorySignature->document_signature_path))
                    ]
                );
            }

            foreach ($fileOtherAttachments as $attachment) {
                OtherAttachments::where('id', $attachment['id'])->update([
                    'path' => $this->getAttachmentPath($attachment['user_id'], $attachment['file_id'], basename($attachment['path']))
                ]);
            }
        }

        return Command::SUCCESS;
    }

    public function getFileVersionPath($userId, $sectionId, $fileId, $versionNumber, $fileName)
    {
        return  $userId . '/' . $sectionId . '/' . $fileId . '/' . $versionNumber . '/' . $fileName;
    }

    public function getFileVersionSignaturePath($userId, $sectionId, $fileId, $versionNumber, $fileName)
    {
        return  $userId . '/' . $sectionId . '/' . $fileId . '/' . $versionNumber . '/with-signature/' . $fileName;
    }

    public function getAttachmentPath($userId, $fileId, $fileName)
    {
        return $userId . '/' . $fileId . '/' . $fileName;
    }
}
