<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;
use Suiterus\Adg\Models\LeaveManagement\LeaveType;
use Suiterus\Adg\Models\LeaveManagement\ForcedLeaveCounter;

class ForceLeaveCounterCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:seed-forced-leave-counter';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Set forced leave counter for all active users';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // we use command instead of seeder for future purposes like configuration of forced leave counter in client side

        $active = 1;
        $users = User::has('employeeMetaInfo')->where('status', $active)->get();

        $initialPoints = LeaveType::where('title', 'Mandatory/Forced Leave')->first()->initial_points;

        foreach ($users as $user) {
            $this->info($user->name);
            ForcedLeaveCounter::updateOrCreate([
                'user_id' => $user->id,
            ], [
                'counter' => $initialPoints
            ]);
        }

        return 0;
    }
}
