<?php

namespace App\Console\Commands;


use Carbon\Carbon;
use Illuminate\Console\Command;
use Suiterus\Adg\Models\EMI\EmployeeMetaInfo;
use Suiterus\Adg\Models\EMI\EmployeeTypeHistory;

class EmployeeTypeHistoryStatusUpdate extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'update:employee-type-history-status';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Employee Type History Update';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $currentDate = Carbon::now()->format('Y-m-d');
        $pending = 3;
        $current = 1;

        $employeeTypeHistories = EmployeeTypeHistory::where([
            ['date_of_effectivity', $currentDate], ['status', $pending]
        ])->get();

        foreach ($employeeTypeHistories as $history) {
            $history->update([
                'status' => $current
            ]);

            $employeeMetaInfo = EmployeeMetaInfo::where('user_id', $history->user_id)->first();
                $employeeMetaInfo->update([
                    'employee_type' => $history->employee_type_id
                ]);
        }
        return Command::SUCCESS;
    }
}
