<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;
use Suiterus\Adg\Models\SM\Office;
use Suiterus\Adg\Models\EMI\EmployeeMetaInfo;

class EmployeeOrganization extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:seed-employee-organization {type} {employee_type} {file_name}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Seeding of employee organization';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $fileNames = explode('|', $this->argument('file_name'));
        $type = $this->argument('type');
        $employeeType = $this->argument('employee_type');

        $devAccount = 2;
        $active = 1;

        $excelEmpIds = [];

        EmployeeMetaInfo::whereHas('employeeType', function($query) use($employeeType){
            $query->where('title', $employeeType);
        })->update([
            'office_id' => null,
            'department_id' => null,
            'division_id' => null,
        ]);

        foreach ($fileNames as $fileName) {
            $this->info('Start seeding of ' . $fileName);

            $row = 1;
            $countProcess = 0;

            $countEmployeeNotExist = 0;
            $fileNotExistPath = public_path(basename($fileName, '.csv') . '-employee-exist-in-excel-not-in-database.csv');
            $fileNotExist = fopen($fileNotExistPath, 'w');
            $employeeInDb = fopen(public_path(basename($fileName, '.csv') . '-employee-exist-in-database-not-in-excel.csv'), 'w');

            fputcsv($fileNotExist, [
                'Employee ID', 'NAME', 'DEPUTY', 'DEPARTMENT', 'DIVISION / SECTION / UNIT (AREA OF ASSIGNMENT)'
            ]);
            if (($handle = fopen(public_path($fileName), "r")) !== FALSE) {
                while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
                    if ($row > 2) {

                        $excelEmpIds[] = sprintf("%06d", $data[0]);

                        $employee = [
                            'employee_no' => sprintf("%06d", $data[0]),
                            'name' => $data[1],
                            'office' => strtoupper($data[2]),
                            'department' => strtoupper($data[3]),
                            'division' => strtoupper($data[4]),
                        ];

                        $user = User::select('id')->whereHas('employeeMetaInfo', function ($query) use ($employee) {
                            $query->where('employee_id', $employee['employee_no']);
                        })->without([
                            'currentRole',
                            'roles',
                            'permissions',
                            'storage',
                            'employeeMetaInfo',
                            'supervisor',
                            'user_supervisor',
                            'exitInterview',
                            'userProfilePicture',
                            'profileBasicInfo'
                        ])->first();

                        if (!$user) {
                            $this->error("Employee not exist: {$employee['employee_no']} {$employee['name']}");
                            fputcsv($fileNotExist, $data);
                            $countEmployeeNotExist++;
                            continue;
                        }

                        $office = null;
                        $department = null;
                        $division = null;

                        $this->info("Importing Employee's Organization: {$employee['name']}");

                        $office = Office::updateOrCreate(
                            [
                                'name' => $employee['office']
                            ],
                            [
                                'status' => $active,
                                'created_by' => $devAccount,
                            ]
                        );

                        if (strtolower($employee['department']) != 'none') {
                            $department = $office->department()->updateOrCreate(
                                [
                                    'name' => $employee['department']
                                ],
                                [
                                    'status' => $active,
                                    'created_by' => $devAccount,
                                ]
                            );
                        }

                        if (isset($department) && strtolower($employee['division']) != 'none') {
                            $division = $department->divisions()->updateOrCreate(
                                [
                                    'name' => $employee['division']
                                ],
                                [
                                    'status' => $active,
                                    'created_by' => $devAccount,
                                ]
                            );
                        } else if (strtolower($employee['division']) != 'none') {
                            $division = $office->divisions()->updateOrCreate(
                                [
                                    'name' => $employee['division']
                                ],
                                [
                                    'status' => $active,
                                    'created_by' => $devAccount,
                                ]
                            );
                        }

                        if ($type == 'area_assignment') {
                            $user->actualDesignation()->updateOrCreate(
                                [
                                    'user_id' => $user->id
                                ],
                                [
                                    'office_id' => $office ? $office->id : null,
                                    'department_id' => $department ? $department->id : null,
                                    'division_id' => $division ? $division->id : null,
                                ]
                            );

                            if (strtolower($employeeType) == 'contractual' || strtolower($employeeType) == 'job order') {
                                $user->employeeMetaInfo()->update(
                                    [
                                        'office_id' => $office ? $office->id : null,
                                        'department_id' => $department ? $department->id : null,
                                        'division_id' => $division ? $division->id : null,
                                    ]
                                );
                            }
                        } else if ($type == 'service_record') {
                            $user->employeeMetaInfo()->update(
                                [
                                    'office_id' => $office ? $office->id : null,
                                    'department_id' => $department ? $department->id : null,
                                    'division_id' => $division ? $division->id : null,
                                ]
                            );
                        }

                        $countProcess++;
                    }
                    $row++;
                }
                fclose($handle);
            }

            $infos = EmployeeMetaInfo::whereNotIn('employee_id', $excelEmpIds)->whereHas('employeeType', function($query) use($employeeType){
                $query->where('title', $employeeType);
            })->get();

            foreach ($infos as $info) {
                fputcsv($employeeInDb, [
                    $info->employee_id,
                    $info->user->name
                ]);
            }

            $this->info('Seeding of ' . $fileName . ' done');
            $this->info('Total ' . $countProcess . ' employee(s) imported');
            $this->info('Total ' . $countEmployeeNotExist . ' employee(s) not exist in database');
            $this->info('File ' . $fileName . '-employee-not-exist.csv created');
            fclose($employeeInDb);
            fclose($fileNotExist);
        }
    }
}
