<?php

namespace App\Console\Commands;

use Illuminate\Support\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Suiterus\Adg\Jobs\DeductFLtoVLJob;
use App\Http\Classes\NotificationMessage;
use Suiterus\Adg\Models\LeaveManagement\LeaveType;
use Suiterus\Adg\Models\LeaveManagement\ForcedLeaveCounter;
use Suiterus\Adg\Models\LeaveManagement\LeaveCreditHistory;
use Suiterus\Adg\Models\LeaveManagement\Crediting\LeaveBalance;
use Suiterus\Adg\Services\EmailNotification\EmailNotificationService;

class DeductForcedLeaveToVacationLeave extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'leave:deduct-forced-leave-to-vacation-leave';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Deduct Forced Leave To Vacation Leave';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $active = 1;

        $leaveBalances = LeaveBalance::whereHas('leave_type', function ($query) {
            $query->where('title', 'Vacation Leave');
        })->whereHas('user', function ($query) use ($active) {
            $query->where('status', $active);
        })->get();
        foreach ($leaveBalances as $leaveBalance) {
            $this->info('dispatching');
            DeductFLtoVLJob::dispatch($leaveBalance);
        }
        return 0;
    }
}
